/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.cosmetics.events;

import gg.essential.cosmetics.events.AnimationEventType;
import gg.essential.event.entity.PlayerTickEvent;
import gg.essential.lib.kbrewster.eventbus.Subscribe;
import gg.essential.mixins.impl.client.entity.AbstractClientPlayerExt;
import gg.essential.mod.cosmetics.CosmeticSlot;
import gg.essential.model.ModelInstance;
import gg.essential.network.cosmetics.Cosmetic;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.world.entity.player.Player;

public class CosmeticEventEmitter {
    public void triggerEvent(UUID playerUuid, CosmeticSlot slot, String event) {
        ClientLevel world = Minecraft.m_91087_().f_91073_;
        if (world == null) {
            return;
        }
        AbstractClientPlayerExt player2 = this.findPlayerByCosmeticsSourceUuid(world, playerUuid);
        if (player2 == null) {
            return;
        }
        if (event.equals("reset")) {
            player2.getWearablesManager().resetModel(slot);
            return;
        }
        Map<Cosmetic, ModelInstance> essentialCosmeticModels = player2.getWearablesManager().getModels();
        for (ModelInstance value : essentialCosmeticModels.values()) {
            if (slot != value.getCosmetic().getType().getSlot()) continue;
            value.getEssentialAnimationSystem().fireTriggerFromAnimation(event, null);
        }
    }

    private AbstractClientPlayerExt findPlayerByCosmeticsSourceUuid(ClientLevel world, UUID uuid) {
        for (Player player2 : world.m_6907_()) {
            AbstractClientPlayerExt playerExt;
            if (!(player2 instanceof AbstractClientPlayerExt) || !(playerExt = (AbstractClientPlayerExt)player2).getCosmeticsSourceUuid().equals(uuid)) continue;
            return playerExt;
        }
        return null;
    }

    public void fireEvent(AbstractClientPlayer player2, AnimationEventType type) {
        Map<Cosmetic, ModelInstance> essentialCosmeticModels = ((AbstractClientPlayerExt)player2).getWearablesManager().getModels();
        for (ModelInstance value : essentialCosmeticModels.values()) {
            value.getEssentialAnimationSystem().processEvent(type);
        }
    }

    @Subscribe
    public void tick(PlayerTickEvent tickEvent) {
        if (tickEvent.isPre()) {
            return;
        }
        Player playerEntity = tickEvent.getPlayer();
        if (!(playerEntity instanceof AbstractClientPlayer)) {
            return;
        }
        this.fireEvent((AbstractClientPlayer)playerEntity, AnimationEventType.TICK);
    }
}

