/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.cosmetics;

import gg.essential.cosmetics.events.AnimationEvent;
import gg.essential.model.BedrockModel;
import gg.essential.model.file.AnimationFile;
import gg.essential.model.file.ParticlesFile;
import gg.essential.model.file.SoundDefinitionsFile;
import gg.essential.network.cosmetics.Cosmetic;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u0006\u0010\r\u001a\u00020\u000eJ\b\u0010\u000f\u001a\u00020\u000eH\u0002J\b\u0010\u0010\u001a\u00020\u000eH\u0002J\u0018\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0018\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\nH\u0002J\u0018\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\nH\u0002J\u0018\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\nH\u0002J\u0010\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lgg/essential/cosmetics/ReferenceChecker;", "", "model", "Lgg/essential/model/BedrockModel;", "diagnostics", "", "Lgg/essential/network/cosmetics/Cosmetic$Diagnostic;", "(Lgg/essential/model/BedrockModel;Ljava/util/List;)V", "referencedAnimations", "", "", "referencedParticles", "referencedSounds", "check", "", "checkForUnusedData", "checkForUnusedFiles", "visitAnimation", "name", "animation", "Lgg/essential/model/file/AnimationFile$Animation;", "visitBone", "referringFile", "visitParticle", "visitSound", "visitTrigger", "trigger", "Lgg/essential/cosmetics/events/AnimationEvent;", "essential-gui-essential"})
@SourceDebugExtension(value={"SMAP\ndiagnostics.kt\nKotlin\n*S Kotlin\n*F\n+ 1 diagnostics.kt\ngg/essential/cosmetics/ReferenceChecker\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,308:1\n1#2:309\n1855#3,2:310\n1855#3,2:312\n1855#3,2:314\n*S KotlinDebug\n*F\n+ 1 diagnostics.kt\ngg/essential/cosmetics/ReferenceChecker\n*L\n235#1:310,2\n226#1:312,2\n227#1:314,2\n*E\n"})
final class ReferenceChecker {
    @NotNull
    private final BedrockModel model;
    @NotNull
    private final List<Cosmetic.Diagnostic> diagnostics;
    @NotNull
    private final Set<String> referencedSounds;
    @NotNull
    private final Set<String> referencedParticles;
    @NotNull
    private final Set<String> referencedAnimations;

    public ReferenceChecker(@NotNull BedrockModel model, @NotNull List<Cosmetic.Diagnostic> diagnostics2) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter(diagnostics2, (String)"diagnostics");
        this.model = model;
        this.diagnostics = diagnostics2;
        this.referencedSounds = new LinkedHashSet();
        this.referencedParticles = new LinkedHashSet();
        this.referencedAnimations = new LinkedHashSet();
    }

    public final void check() {
        Object object = this.model.getAnimationData();
        if (object == null || (object = ((AnimationFile)object).getTriggers()) == null) {
            object = CollectionsKt.emptyList();
        }
        Iterator iterator2 = object.iterator();
        while (iterator2.hasNext()) {
            AnimationEvent trigger = (AnimationEvent)iterator2.next();
            this.visitTrigger(trigger);
        }
        this.checkForUnusedFiles();
        this.checkForUnusedData();
    }

    private final void checkForUnusedFiles() {
        Set unusedFiles = CollectionsKt.toMutableSet((Iterable)this.model.getCosmetic().assets(this.model.getVariant()).getOtherFiles().keySet());
        for (String file : this.model.getParticleData().keySet()) {
            unusedFiles.remove(file);
        }
        Object object = this.model.getSoundData();
        if (object == null || (object = ((SoundDefinitionsFile)object).getDefinitions()) == null || (object = object.values()) == null) {
            object = CollectionsKt.emptyList();
        }
        Iterator<String> iterator2 = object.iterator();
        while (iterator2.hasNext()) {
            SoundDefinitionsFile.Definition soundEffect = (SoundDefinitionsFile.Definition)((Object)iterator2.next());
            for (SoundDefinitionsFile.Sound sound : soundEffect.getSounds()) {
                unusedFiles.remove(sound.getName() + ".ogg");
            }
        }
        for (String file : unusedFiles) {
            String msg = "File is unused.";
            this.diagnostics.add(Cosmetic.Diagnostic.Companion.warning$default(Cosmetic.Diagnostic.Companion, msg, null, file, null, null, null, 58, null));
        }
    }

    private final void checkForUnusedData() {
        String msg;
        Object object = this.model.getAnimationData();
        for (String string : object != null && (object = ((AnimationFile)object).getAnimations()) != null && (object = object.keySet()) != null ? (Collection)object : (Collection)CollectionsKt.emptyList()) {
            if (this.referencedAnimations.contains(string)) continue;
            msg = "Animation `" + string + "` is unused.";
            this.diagnostics.add(Cosmetic.Diagnostic.Companion.warning$default(Cosmetic.Diagnostic.Companion, msg, null, "animations.json", null, null, null, 58, null));
        }
        for (Map.Entry entry : this.model.getParticleData().entrySet()) {
            String file = (String)entry.getKey();
            ParticlesFile data = (ParticlesFile)entry.getValue();
            String name3 = data.getParticleEffect().getDescription().getIdentifier();
            if (this.referencedParticles.contains(name3)) continue;
            String msg2 = "Particle effect `" + name3 + "` is unused.";
            this.diagnostics.add(Cosmetic.Diagnostic.Companion.warning$default(Cosmetic.Diagnostic.Companion, msg2, null, file, null, null, null, 58, null));
        }
        Object object2 = this.model.getSoundData();
        for (String string : object2 != null && (object2 = ((SoundDefinitionsFile)object2).getDefinitions()) != null && (object2 = object2.keySet()) != null ? (Collection)object2 : (Collection)CollectionsKt.emptyList()) {
            if (this.referencedSounds.contains(string)) continue;
            msg = "Sound effect `" + string + "` is unused.";
            this.diagnostics.add(Cosmetic.Diagnostic.Companion.warning$default(Cosmetic.Diagnostic.Companion, msg, null, "sounds/sound_definitions.json", null, null, null, 58, null));
        }
    }

    private final void visitBone(String name2, String referringFile) {
        if (!this.model.getBones().contains(name2)) {
            String msg = "Referenced bone `" + name2 + "` not found.";
            this.diagnostics.add(Cosmetic.Diagnostic.Companion.error$default(Cosmetic.Diagnostic.Companion, msg, null, referringFile, null, null, null, 58, null));
        }
    }

    private final void visitSound(String name2, String referringFile) {
        Object object = this.model.getSoundData();
        if ((object != null && (object = ((SoundDefinitionsFile)object).getDefinitions()) != null ? (SoundDefinitionsFile.Definition)object.get(name2) : null) == null) {
            String msg = "Referenced sound effect `" + name2 + "` not found.";
            this.diagnostics.add(Cosmetic.Diagnostic.Companion.error$default(Cosmetic.Diagnostic.Companion, msg, null, referringFile, null, null, null, 58, null));
            return;
        }
        this.referencedSounds.add(name2);
    }

    private final void visitParticle(String name2, String referringFile) {
        Pair entry;
        Pair pair;
        Object v0;
        block5: {
            Iterable iterable = this.model.getParticleData().entrySet();
            for (Object object : iterable) {
                Map.Entry it = (Map.Entry)object;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)((ParticlesFile)it.getValue()).getParticleEffect().getDescription().getIdentifier(), (Object)name2)) continue;
                v0 = object;
                break block5;
            }
            v0 = null;
        }
        Map.Entry entry2 = v0;
        if (entry2 != null) {
            Map.Entry it = entry2;
            boolean bl = false;
            pair = TuplesKt.to(it.getKey(), (Object)((ParticlesFile)it.getValue()).getParticleEffect());
        } else {
            pair = entry = null;
        }
        if (entry == null) {
            String msg = "Referenced particle effect `" + name2 + "` not found.";
            this.diagnostics.add(Cosmetic.Diagnostic.Companion.error$default(Cosmetic.Diagnostic.Companion, msg, null, referringFile, null, null, null, 58, null));
            return;
        }
        String sourceFile = (String)entry.component1();
        ParticlesFile.ParticleEffect particleEffect = (ParticlesFile.ParticleEffect)entry.component2();
        this.referencedParticles.add(name2);
        Iterable $this$forEach$iv = particleEffect.getEvents().values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ParticlesFile.Event p0 = (ParticlesFile.Event)element$iv;
            boolean bl = false;
            ReferenceChecker.visitParticle$visitEvent(this, sourceFile, p0);
        }
    }

    private final void visitAnimation(String name2, AnimationFile.Animation animation) {
        String it;
        boolean bl;
        this.referencedAnimations.add(name2);
        String file = "animations.json";
        for (List<AnimationFile.Animation.ParticleEffect> list : animation.getParticleEffects().values()) {
            for (AnimationFile.Animation.ParticleEffect effect2 : list) {
                this.visitParticle(effect2.getEffect(), file);
                if (effect2.getLocator() == null) continue;
                bl = false;
                this.visitBone(it, file);
            }
        }
        for (List<Object> list : animation.getSoundEffects().values()) {
            for (AnimationFile.Animation.SoundEffect effect2 : list) {
                this.visitSound(effect2.getEffect(), file);
                if (effect2.getLocator() == null) continue;
                bl = false;
                this.visitBone(it, file);
            }
        }
        for (String string : animation.getBones().keySet()) {
            this.visitBone(string, file);
        }
    }

    private final void visitTrigger(AnimationEvent trigger) {
        block2: {
            AnimationFile.Animation animation;
            Object object = this.model.getAnimationData();
            AnimationFile.Animation animation2 = object != null && (object = ((AnimationFile)object).getAnimations()) != null ? (AnimationFile.Animation)object.get(trigger.getName()) : (animation = null);
            if (animation == null) {
                String msg = "Referenced animation `" + trigger.getName() + "` not found.";
                this.diagnostics.add(Cosmetic.Diagnostic.Companion.error$default(Cosmetic.Diagnostic.Companion, msg, null, "animations.json", null, null, null, 58, null));
            } else {
                this.visitAnimation(trigger.getName(), animation);
            }
            AnimationEvent animationEvent = trigger.getOnComplete();
            if (animationEvent == null) break block2;
            AnimationEvent it = animationEvent;
            boolean bl = false;
            this.visitTrigger(it);
        }
    }

    private static final void visitParticle$visitEvent(ReferenceChecker this$0, String sourceFile, ParticlesFile.Event event) {
        block5: {
            Object it;
            boolean $i$f$forEach;
            Iterable $this$forEach$iv;
            List<ParticlesFile.Event> list = event.getSequence();
            if (list != null) {
                $this$forEach$iv = list;
                $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    it = (ParticlesFile.Event)element$iv;
                    boolean bl = false;
                    ReferenceChecker.visitParticle$visitEvent(this$0, sourceFile, (ParticlesFile.Event)it);
                }
            }
            List<ParticlesFile.Event.RandomizeOption> list2 = event.getRandomize();
            if (list2 != null) {
                $this$forEach$iv = list2;
                $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    it = (ParticlesFile.Event.RandomizeOption)element$iv;
                    boolean bl = false;
                    ReferenceChecker.visitParticle$visitEvent(this$0, sourceFile, ((ParticlesFile.Event.RandomizeOption)it).getValue());
                }
            }
            ParticlesFile.Event.Particle particle = event.getParticle();
            if (particle != null) {
                ParticlesFile.Event.Particle options2 = particle;
                boolean bl = false;
                this$0.visitParticle(options2.getEffect(), sourceFile);
            }
            ParticlesFile.Event.Sound sound = event.getSound();
            if (sound == null) break block5;
            ParticlesFile.Event.Sound options3 = sound;
            boolean bl = false;
            this$0.visitSound(options3.getEvent(), sourceFile);
        }
    }
}

