/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.commands.impl;

import gg.essential.Essential;
import gg.essential.network.connectionmanager.ConnectionManager;
import gg.essential.network.connectionmanager.social.SocialManager;
import gg.essential.network.connectionmanager.sps.SPSManager;
import gg.essential.util.MinecraftUtils;
import gg.essential.util.ServerType;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u001a'\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0001\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Ljava/util/UUID;", "uuid", "", "username", "", "kick", "", "cancelInviteAndKick", "(Ljava/util/UUID;Ljava/lang/String;Z)V", "Essential 1.20.1-forge"})
public final class SPSHostCommandsKt {
    private static final void cancelInviteAndKick(UUID uuid, String username, boolean kick) {
        ConnectionManager connectionManager = Essential.getInstance().getConnectionManager();
        Intrinsics.checkNotNullExpressionValue((Object)connectionManager, (String)"getConnectionManager(...)");
        ConnectionManager connectionManager2 = connectionManager;
        SPSManager sPSManager = connectionManager2.getSpsManager();
        Intrinsics.checkNotNullExpressionValue((Object)sPSManager, (String)"getSpsManager(...)");
        SPSManager spsManager = sPSManager;
        ServerType serverType = ServerType.Companion.current();
        if (!(serverType instanceof ServerType.SPS.Host)) {
            if (!(serverType instanceof ServerType.Multiplayer)) {
                MinecraftUtils.INSTANCE.sendMessage("Cannot cancel invite because you are not currently on a session that supports invites");
                return;
            }
            Set<UUID> invites = connectionManager2.getSocialManager().getInvitesOnServer(((ServerType.Multiplayer)serverType).getAddress());
            if (!invites.contains(uuid)) {
                MinecraftUtils.INSTANCE.sendMessage("Cannot cancel invite because " + username + " is not invited to your current session");
                return;
            }
            SocialManager socialManager = connectionManager2.getSocialManager();
            String string = ((ServerType.Multiplayer)serverType).getAddress();
            Intrinsics.checkNotNull(invites);
            socialManager.setInvitedFriendsOnServer(string, SetsKt.minus(invites, (Object)uuid));
            MinecraftUtils.INSTANCE.sendMessage("Cancelled invite to " + username);
            return;
        }
        if (!spsManager.getInvitedUsers().contains(uuid)) {
            MinecraftUtils.INSTANCE.sendMessage(username + " is not invited to your world.");
            return;
        }
        Set<UUID> set2 = spsManager.getInvitedUsers();
        Intrinsics.checkNotNullExpressionValue(set2, (String)"getInvitedUsers(...)");
        spsManager.updateInvitedUsers(SetsKt.minus(set2, (Object)uuid));
        if (kick) {
            MinecraftUtils.INSTANCE.sendMessage("Kicked " + username);
        } else {
            MinecraftUtils.INSTANCE.sendMessage("Canceled invite to " + username);
        }
    }

    public static final /* synthetic */ void access$cancelInviteAndKick(UUID uuid, String username, boolean kick) {
        SPSHostCommandsKt.cancelInviteAndKick(uuid, username, kick);
    }
}

