/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.asm;

import gg.essential.asm.MixinTransformerWrapper;
import java.nio.charset.StandardCharsets;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;

public class GlErrorCheckingTransformer
implements MixinTransformerWrapper.Transformer {
    private static final int ASM_VERSION = 589824;
    private static final String OPENGL_PACKAGE = "org.lwjgl.opengl.";
    private static final String OPENGL_PACKAGE_JVM = "org.lwjgl.opengl.".replace('.', '/');
    private static final byte[] OPENGL_PACKAGE_JVM_BYTES = OPENGL_PACKAGE_JVM.getBytes(StandardCharsets.UTF_8);
    private static final String GL11_JVM = OPENGL_PACKAGE_JVM + "GL11";
    private static final String GL_DEBUG = "gg.essential.util.GlDebug";
    private static final String GL_DEBUG_JVM = "gg.essential.util.GlDebug".replace('.', '/');
    private static final String IN_BEGIN_END_PAIR = "inBeginEndPair";
    private static final String CHECK = "checkGlError";
    private static final String CHECK_DESC = "(Ljava/lang/String;)V";

    @Override
    public byte[] transform(String name2, String transformedName, byte[] bytes) {
        if (bytes == null || !GlErrorCheckingTransformer.contains(bytes, OPENGL_PACKAGE_JVM_BYTES)) {
            return bytes;
        }
        if (name2.startsWith(GlErrorCheckingTransformer.class.getName())) {
            return bytes;
        }
        if (name2.startsWith(GL_DEBUG)) {
            return bytes;
        }
        if (name2.startsWith(OPENGL_PACKAGE)) {
            return bytes;
        }
        ClassReader classReader = new ClassReader(bytes);
        ClassWriter classWriter = new ClassWriter(0);
        classReader.accept(new ClassVisitor(589824, (ClassVisitor)classWriter){

            public MethodVisitor visitMethod(int access, String name2, String desc, String signature, String[] exceptions) {
                return new MethodVisitor(589824, super.visitMethod(access, name2, desc, signature, exceptions)){

                    public void visitMethodInsn(int opcode, String owner, String name2, String desc, boolean itf) {
                        if (opcode != 184 || !owner.startsWith(OPENGL_PACKAGE_JVM)) {
                            super.visitMethodInsn(opcode, owner, name2, desc, itf);
                            return;
                        }
                        super.visitLdcInsn((Object)("**BEFORE** " + name2));
                        super.visitMethodInsn(184, GL_DEBUG_JVM, GlErrorCheckingTransformer.CHECK, GlErrorCheckingTransformer.CHECK_DESC, false);
                        super.visitMethodInsn(opcode, owner, name2, desc, itf);
                        if (owner.equals(GL11_JVM) && name2.equals("glBegin")) {
                            super.visitLdcInsn((Object)true);
                            super.visitFieldInsn(179, GL_DEBUG_JVM, GlErrorCheckingTransformer.IN_BEGIN_END_PAIR, "Z");
                        }
                        if (owner.equals(GL11_JVM) && name2.equals("glEnd")) {
                            super.visitLdcInsn((Object)false);
                            super.visitFieldInsn(179, GL_DEBUG_JVM, GlErrorCheckingTransformer.IN_BEGIN_END_PAIR, "Z");
                        }
                        super.visitLdcInsn((Object)name2);
                        super.visitMethodInsn(184, GL_DEBUG_JVM, GlErrorCheckingTransformer.CHECK, GlErrorCheckingTransformer.CHECK_DESC, false);
                    }

                    public void visitMaxs(int maxStack, int maxLocals) {
                        super.visitMaxs(maxStack + 1, maxLocals);
                    }
                };
            }
        }, 0);
        return classWriter.toByteArray();
    }

    private static boolean contains(byte[] array, byte[] needle) {
        block0: for (int i2 = 0; i2 < array.length - needle.length + 1; ++i2) {
            for (int j = 0; j < needle.length; ++j) {
                if (array[i2 + j] != needle[j]) continue block0;
            }
            return true;
        }
        return false;
    }
}

