/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.component;

import java.util.Objects;
import journeymap.client.render.RenderWrapper;
import journeymap.client.ui.GuiUtils;
import journeymap.client.ui.component.BooleanPropertyButton;
import journeymap.common.properties.config.BooleanField;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.renderer.GameRenderer;

public class CheckBox
extends BooleanPropertyButton {
    public int boxWidth = 11;
    String glyph = "\u2714";

    public CheckBox(String label, boolean checked, Button.OnPress pressable) {
        this(label, null, pressable);
        this.toggled = checked;
    }

    public CheckBox(String label, BooleanField field, Button.OnPress pressable) {
        super(label, label, field, pressable);
        Objects.requireNonNull(this.fontRenderer);
        this.setHeight(9 + 2);
        this.m_93674_(this.getFitWidth(this.fontRenderer));
    }

    public CheckBox(String label, boolean checked) {
        this(label, checked, CheckBox.emptyPressable());
    }

    public CheckBox(String label, BooleanField field) {
        this(label, field, CheckBox.emptyPressable());
    }

    @Override
    public int getFitWidth(Font fr) {
        return super.getFitWidth(fr) + this.boxWidth + 2;
    }

    @Override
    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float ticks) {
        if (this.f_93624_) {
            this.setHovered(this.isEnabled() && mouseX >= super.m_252754_() && mouseY >= super.m_252907_() && mouseX < super.m_252754_() + this.f_93618_ && mouseY < super.m_252907_() + this.f_93619_);
            int yoffset = (this.f_93619_ - this.boxWidth) / 2;
            RenderWrapper.setShader(GameRenderer::m_172817_);
            GuiUtils.drawContinuousTexturedBox(graphics.m_280168_(), f_93617_, super.m_252754_(), super.m_252907_() + yoffset, 0, 46, this.boxWidth, this.boxWidth, 200, 20, 2, 3, 2, 2, 0.0f);
            this.m_7979_(mouseX, mouseY, 0, super.m_252754_(), super.m_252907_());
            int color = 0xE0E0E0;
            if (this.m_274382_()) {
                color = 0xFFFFA0;
            } else if (!this.isEnabled()) {
                color = 0x404040;
            } else if (this.labelColor != null) {
                color = this.labelColor;
            } else if (this.getActiveColor() != 0) {
                color = this.getActiveColor();
            }
            int labelPad = 4;
            if (this.toggled.booleanValue()) {
                graphics.m_280137_(this.fontRenderer, this.glyph, super.m_252754_() + this.boxWidth / 2 + 1, super.m_252907_() + 1 + yoffset, color);
            }
            graphics.m_280430_(this.fontRenderer, this.m_6035_(), super.m_252754_() + this.boxWidth + labelPad, super.m_252907_() + 2 + yoffset, color);
        }
    }

    @Override
    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.isEnabled() && this.f_93624_ && mouseX >= (double)super.m_252754_() && mouseY >= (double)super.m_252907_() && mouseX < (double)(super.m_252754_() + this.f_93618_) && mouseY < (double)(super.m_252907_() + this.f_93619_)) {
            this.toggle();
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean keyTyped(char c, int i) {
        if (this.isEnabled() && i == 32) {
            this.toggle();
            return true;
        }
        return false;
    }
}

