/*
 * Decompiled with CFR 0.152.
 */
package org.sinytra.connector.service.hacks;

import com.mojang.logging.LogUtils;
import cpw.mods.jarhandling.SecureJar;
import cpw.mods.modlauncher.Launcher;
import cpw.mods.modlauncher.api.IModuleLayerManager;
import cpw.mods.modlauncher.api.LamdbaExceptionUtils;
import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.lang.module.ModuleDescriptor;
import java.lang.module.ModuleReference;
import java.lang.module.ResolvedModule;
import java.lang.reflect.Field;
import java.net.URI;
import java.nio.file.Path;
import java.security.CodeSigner;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.slf4j.Logger;
import sun.misc.Unsafe;

public class ModuleLayerMigrator {
    public static final MethodHandles.Lookup TRUSTED_LOOKUP = (MethodHandles.Lookup)LamdbaExceptionUtils.uncheck(() -> {
        Field theUnsafe = Unsafe.class.getDeclaredField("theUnsafe");
        theUnsafe.setAccessible(true);
        Unsafe unsafe = (Unsafe)theUnsafe.get(null);
        Field hackfield = MethodHandles.Lookup.class.getDeclaredField("IMPL_LOOKUP");
        return (MethodHandles.Lookup)unsafe.getObject(unsafe.staticFieldBase(hackfield), unsafe.staticFieldOffset(hackfield));
    });
    private static final Class<?> JAR_MODULE_REF_CLASS = (Class)LamdbaExceptionUtils.uncheck(() -> Class.forName("cpw.mods.cl.JarModuleFinder$JarModuleReference"));
    private static final VarHandle REF_MODULE_PROVIDER_FIELD = (VarHandle)LamdbaExceptionUtils.uncheck(() -> TRUSTED_LOOKUP.findVarHandle(JAR_MODULE_REF_CLASS, "jar", SecureJar.ModuleDataProvider.class));
    private static final VarHandle DESCRIPTOR_PACKAGES_FIELD = (VarHandle)LamdbaExceptionUtils.uncheck(() -> TRUSTED_LOOKUP.findVarHandle(ModuleDescriptor.class, "packages", Set.class));
    private static final Logger LOGGER = LogUtils.getLogger();

    public static SecureJar moveModule(String moduleName) {
        try {
            LOGGER.debug("Attempting to make module {} transformable", (Object)moduleName);
            ModuleLayer layer = (ModuleLayer)((IModuleLayerManager)Launcher.INSTANCE.findLayerManager().orElseThrow()).getLayer(IModuleLayerManager.Layer.BOOT).orElseThrow();
            ResolvedModule module = layer.configuration().findModule(moduleName).orElseThrow(() -> new RuntimeException("Module %s not found".formatted(moduleName)));
            Module actualModule = layer.findModule(moduleName).orElseThrow(() -> new RuntimeException("Module %s not found".formatted(moduleName)));
            ModuleReference reference = module.reference();
            if (!JAR_MODULE_REF_CLASS.isInstance(reference)) {
                throw new RuntimeException("Module %s does not contain a jar module reference".formatted(moduleName));
            }
            SecureJar.ModuleDataProvider originalProvider = REF_MODULE_PROVIDER_FIELD.get(reference);
            EmptyModuleDataProvider wrappedProvider = new EmptyModuleDataProvider(originalProvider.name());
            REF_MODULE_PROVIDER_FIELD.set(reference, wrappedProvider);
            ModuleDescriptor desc = actualModule.getDescriptor();
            DESCRIPTOR_PACKAGES_FIELD.set(desc, Set.of());
            LOGGER.info("Successfully made module {} transformable", (Object)moduleName);
            ModuleDataProviderWrapper provider = new ModuleDataProviderWrapper(originalProvider, "connector$" + moduleName);
            return new SimpleSecureJar(provider);
        }
        catch (Throwable t) {
            throw new RuntimeException("Error making module %s transformable".formatted(moduleName), t);
        }
    }

    private static class EmptyModuleDataProvider
    implements SecureJar.ModuleDataProvider {
        private final String name;
        private ModuleDescriptor descriptor;

        public EmptyModuleDataProvider(String name) {
            this.name = name;
        }

        public ModuleDescriptor descriptor() {
            if (this.descriptor == null) {
                this.descriptor = ModuleDescriptor.newAutomaticModule(this.name()).build();
            }
            return this.descriptor;
        }

        public String name() {
            return this.name;
        }

        public URI uri() {
            return (URI)LamdbaExceptionUtils.uncheck(() -> new URI("file:///~nonexistent"));
        }

        public Optional<URI> findFile(String name) {
            return Optional.empty();
        }

        public Optional<InputStream> open(String name) {
            return Optional.empty();
        }

        public Manifest getManifest() {
            return new Manifest();
        }

        public CodeSigner[] verifyAndGetSigners(String cname, byte[] bytes) {
            return new CodeSigner[0];
        }
    }

    private static class ModuleDataProviderWrapper
    implements SecureJar.ModuleDataProvider {
        private final SecureJar.ModuleDataProvider provider;
        private final String name;
        private ModuleDescriptor descriptor;

        public ModuleDataProviderWrapper(SecureJar.ModuleDataProvider provider, String name) {
            this.provider = provider;
            this.name = name;
        }

        public ModuleDescriptor descriptor() {
            if (this.descriptor == null) {
                ModuleDescriptor desc = this.provider.descriptor();
                ModuleDescriptor.Builder builder = ModuleDescriptor.newModule(this.name, desc.modifiers());
                builder.packages(desc.packages());
                if (!desc.isAutomatic()) {
                    desc.version().ifPresent(builder::version);
                    desc.requires().forEach(builder::requires);
                    desc.exports().forEach(builder::exports);
                    desc.opens().forEach(builder::opens);
                    desc.uses().forEach(builder::uses);
                    desc.provides().forEach(builder::provides);
                }
                this.descriptor = builder.build();
            }
            return this.descriptor;
        }

        public String name() {
            return this.name;
        }

        public URI uri() {
            return this.provider.uri();
        }

        public Optional<URI> findFile(String name) {
            return this.provider.findFile(name);
        }

        public Optional<InputStream> open(String name) {
            return this.provider.open(name);
        }

        public Manifest getManifest() {
            return this.provider.getManifest();
        }

        public CodeSigner[] verifyAndGetSigners(String cname, byte[] bytes) {
            return this.provider.verifyAndGetSigners(cname, bytes);
        }
    }

    private record SimpleSecureJar(SecureJar.ModuleDataProvider moduleDataProvider) implements SecureJar
    {
        public Path getPrimaryPath() {
            return Path.of(this.moduleDataProvider().uri());
        }

        public CodeSigner[] getManifestSigners() {
            return new CodeSigner[0];
        }

        public SecureJar.Status verifyPath(Path path) {
            return SecureJar.Status.NONE;
        }

        public SecureJar.Status getFileStatus(String name) {
            return SecureJar.Status.NONE;
        }

        public Attributes getTrustedManifestEntries(String name) {
            return new Attributes();
        }

        public boolean hasSecurityData() {
            return false;
        }

        public Set<String> getPackages() {
            return this.moduleDataProvider().descriptor().packages();
        }

        public List<SecureJar.Provider> getProviders() {
            return List.of();
        }

        public String name() {
            return this.moduleDataProvider().name();
        }

        public Path getPath(String first, String ... rest) {
            return this.getPrimaryPath();
        }

        public Path getRootPath() {
            return this.getPrimaryPath();
        }
    }
}

